<?php
class Add_image_model extends CI_Model
{

    private $original_path;
    private $resized_path;
    private $thumbs_path;

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
        //return the full path of the directory
        //make sure these directories have read and write permessions
         $this->original_path = 'uploads/allimages';
        $this->resized_path = 'uploads/allimages/resized/';
        $this->thumbs_path = 'uploads/allimages/thumbs/';
    }

    public function image_upload($file, $rsize_w, $rsize_h, $thumb_w, $thumb_h)
    {
        //set preferences

        //allowed file types. * means all types
        $config['allowed_types'] = '*';
        //allowed max file size. 0 means unlimited file size
        $config['max_size'] = '0';
        //max file name size
        $config['max_filename'] = '255';
        //whether file name should be encrypted or not
        $config['encrypt_name'] = FALSE;
        //store image info once uploaded
        $image_data = array();
        //check for errors
        $is_file_error = FALSE;
        //check if file was selected for upload
        if (!$_FILES) {
            $is_file_error = TRUE;
            $this->session->set_flashdata("error", 'Select an image file.');
        }
        //if file was selected then proceed to upload
        if (!$is_file_error) {

            //file upload destination
            $upload_path = $this->original_path;
            $config['upload_path'] = $upload_path;

            //load the preferences
            $this->load->library('upload', $config);
            //check file successfully uploaded. 'image_name' is the name of the input
            if (!$this->upload->do_upload($file)) {
                //if file upload failed then catch the errors
                $this->session->set_flashdata("error", $this->upload->display_errors());
                $is_file_error = TRUE;

            } else {

                //store the file info
                $image_data = $this->upload->data();

                $config = array(
                    'image_library' => 'gd2',
                    'source_image' => $image_data['full_path'], //path to the uploaded image
                    'new_image' => $this->resized_path, //path to
                    'maintain_ratio' => true,
                    'width' => $rsize_w,
                    'height' => $rsize_h
                );

                //this is the magic line that enables you generate multiple thumbnails
                //you have to call the initialize() function each time you call the resize()
                //otherwise it will not work and only generate one thumbnail
                $this->image_lib->initialize($config);
                $this->image_lib->resize();

                $config = array(
                    'image_library' => 'gd2',
                    'source_image' => $image_data['full_path'], //path to the uploaded image
                    'new_image' => $this->thumbs_path, //path to
                    'maintain_ratio' => true,
                    'width' => $thumb_w,
                    'height' => $thumb_h
                );

                //this is the magic line that enables you generate multiple thumbnails
                //you have to call the initialize() function each time you call the resize()
                //otherwise it will not work and only generate one thumbnail
                $this->image_lib->initialize($config);
                $this->image_lib->resize();

            }


        }
        return array('filedata' => $image_data, 'error' => $is_file_error);
    }

    function insert(){
        $this->load->library('image_lib');
        $img = $_FILES['img'];
        for($i=0;$i<count($img['name']);$i++){
            $_FILES['photo']['name'] 	 = $img['name'][$i];
            $_FILES['photo']['type'] 	 = $img['type'][$i];
            $_FILES['photo']['tmp_name'] = $img['tmp_name'][$i];
            $_FILES['photo']['error'] 	 = $img['error'][$i];
            $_FILES['photo']['size'] 	 = $img['size'][$i];
//            watemark code start

            $config['source_image'] = $_FILES['photo']['tmp_name'] = $img['tmp_name'][$i];
            $config['wm_text'] = 'Order Now';
            $config['wm_type'] = 'text';
//            $config['wm_font_path'] = './system/fonts/texb.ttf';
            $config['wm_font_size'] = '24';
            $config['wm_font_color'] = '#ffff';
            $config['wm_vrt_alignment'] = 'bottom';
            $config['wm_hor_alignment'] = 'center';
            $config['wm_padding'] = '20';

            $this->image_lib->initialize($config);

            $this->image_lib->watermark();


//            watemark code END


            $returnd =  $this->image_upload('photo', 450, 450, 150, 150);
            $filename = $returnd['filedata']['file_name'];
            $dd = array(
                'name'=>$filename
            );
            $as = $this->db->insert('onlyimages', $dd);


        }
        if($as){
            return true;
        }else{
            return false;
        }
    }
}