<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'home';
$route['^(products|index|tag)(/:any)?$'] = "Detail/$0";
$route['^(checkouts|index)(/:any)?$'] = "Order/$0";
$route['^(collections)(/:any)?$'] = "Category/$0";
$route['^(results)(/:any)?$'] = "Search/$0";
$route['^(shop)(/:any)?$'] = "Shopping/$0";
$route['^(contact)(/:any)?$'] = "Contect_us/$0";
$route['^(about)(/:any)?$'] = "About_us/$0";
$route['^(sitemap)(/:any)?$'] = "Xml_controler/$0";
$route['^(term_and_condition)(/:any)?$'] = "Term_condition/$0";
$route['^(payment)(/:any)?$'] = "Payments/$0";
$route['^(single_deal|Deals)(/:any)?$'] = "Deals/$0";
$route['^(privacy_and_policy)(/:any)?$'] = "privacy_policy/$0";
$route['^(order_method)(/:any)?$'] = "how_to_order/$0";
$route['^(delivery_information)(/:any)?$'] = "delivery_information/$0";
$route['^(warranty_terms)(/:any)?$'] = "warranty_terms/$0";
$route['^(return_and_exchange)(/:any)?$'] = "return_exchange/$0";
$route['^(track_your_order)(/:any)?$'] = "track_your_order/$0";
$route['^(special_offer)(/:any)?$'] = "special_discount_offer/$0";
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;
require_once( BASEPATH .'database/DB.php');
$db =& DB();

$query = $db->query("select * from product where slug != '' ")->result_array();
foreach ($query as $v){
    $tag = $v['tags'];
     $tagsi = explode(',', $tag);
    
    foreach ($tagsi as $tagx){
        
    $route['product-tag/'.$slug = preg_replace('/[^a-zA-Z0-9]+/i', '-', $tagx )] = 'Detail/tag/'.$slug = preg_replace('/[^a-zA-Z0-9]+/i', '-', $tagx );
    }
}
$q = $db->query("select * from category where slug != '' ")->result_array();
foreach ($q as $v1){
    
    $route['product-category/'.$v1['slug']] = 'Category/categories/'.$v1['slug'];
}
$route['about-us'] = 'About_us/about';
$route['contact-us'] = 'Contect_us/contact';