<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->load->model('admin/Add_order_model');
        $this->load->model('admin/Add_banner_model');
        $this->load->library('session');
    }

    // Order form page
    public function index()
    {
        $sl_data['banner'] = $this->Add_banner_model->get_all();
        $this->load->view('header', $sl_data);
        $this->load->view('order');
        $this->load->view('footer');
    }

    // Checkout page
    public function checkouts($ord)
    {
        $data['ord'] = $ord;
        $sl_data['banner'] = $this->Add_banner_model->get_all();
        $this->load->view('header', $sl_data);
        $this->load->view('order', $data);
        $this->load->view('footer');
    }

    // Add order
    public function add_order()
    {
        $inserted = $this->Add_order_model->db_insert($_POST);

        // DEBUG: Remove this after confirming
        // var_dump($inserted); exit;

        // Check exactly what db_insert returns
        if($inserted === 1 || $inserted === true) {
            // Success
            $this->session->set_flashdata('success', 'Your order has been placed successfully!');
            redirect(base_url('index.php/Order/thankyou'));
        } else {
            // Error or missing fields
            $this->session->set_flashdata('error', 'Please fill all required fields or something went wrong.');
            redirect(base_url('index.php/Order/thankyou'));
        }
    }

    // Thank you page
    public function thankyou()
    {
        $sl_data['banner'] = $this->Add_banner_model->get_all();
        $this->load->view('header', $sl_data);

        // Show flash message alert
        if($this->session->flashdata('success')) {
            echo '<script>alert("'.$this->session->flashdata('success').'");</script>';
        }

        $this->load->view('thankyou');
        $this->load->view('footer');
    }

    // Product rating
    public function rating()
    {
        $inserted = $this->Add_order_model->db_insert_review($_POST);
        $slug = $_POST['product_slug'];
        if($inserted) {
            $this->session->set_flashdata('success', 'Thanks for your review!');
            redirect(base_url('index.php/products/'.$slug));
        }
    }
}
